import { string } from 'alga-js'
import refreshTokenHelper from "../../../utils/refreshTokenHelper"
import getTokenHelper from "../../../utils/getTokenHelper"
import forceLogoutHelper from "../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../utils/errorHandlingHelper"
import fetchHelper from "../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const config = useRuntimeConfig()
  const token = authToken ?? await getTokenHelper(event)
  const organizationId = getCookie(event, 'organizationId')
  const id = getRouterParam(event, 'id')

  const queryParams = `$filter=${string.urlEncode('C_Order_ID eq '+id)}&$orderby=${string.urlEncode('M_Inout_ID desc')}&$select=IsCommissioned,TrackingNo,IsCommissionedConfirmed,DocStatus`
  const res: any = await fetchHelper(event, `models/m_inout?${queryParams}`, 'GET', token, null)
  if(res?.records) {
    data = res?.records?.[0] || {}
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
    }
  }

  return data
})